#ifndef _GeometryData_h__
#define _GeometryData_h__

#include <GSTenums.h>
#include <buildspec.h>

#include <string>
#include <vector>

namespace GST
{
namespace Transport
{

struct GST_API_EXPORT DataIdent
{
	std::string fileType;
	unsigned long fileLength;
};

struct GST_API_EXPORT GeometryData
{
	// SRSPtr
	Geometry::GeometryTypes geomtype;
	long numberOfVertices;
	long numberOfSimplices;
	std::string prosNames;
	std::vector<DataIdent> dataIdents;
};

} // namespace Transport
} // namespace GST

#endif // _GeometryData_h__
